
try: paraview.simple
except: from paraview.simple import *

def RequestDataDescription(datadescription):
    "Callback to populate the request for current timestep"
    if datadescription.GetForceOutput() == True:
        for i in range(datadescription.GetNumberOfInputDescriptions()):
            datadescription.GetInputDescription(i).AllFieldsOn()
            datadescription.GetInputDescription(i).GenerateMeshOn()
        return

    timestep = datadescription.GetTimeStep()

    input_name = 'input'
    if (timestep % 1 == 0) :
        datadescription.GetInputDescriptionByName(input_name).AllFieldsOn()
        datadescription.GetInputDescriptionByName(input_name).GenerateMeshOn()
    else:
        datadescription.GetInputDescriptionByName(input_name).AllFieldsOff()
        datadescription.GetInputDescriptionByName(input_name).GenerateMeshOff()


def DoCoProcessing(datadescription):
    "Callback to do co-processing for current timestep"
    cp_writers = []
    timestep = datadescription.GetTimeStep()

    a2DRenderView2 = CreateRenderView()
    a2DRenderView2.LightSpecularColor = [1.0, 1.0, 1.0]
    a2DRenderView2.KeyLightAzimuth = 10.0
    a2DRenderView2.UseTexturedBackground = 0
    a2DRenderView2.UseLight = 0
    a2DRenderView2.CameraPosition = [-0.5, 0.0, 15.052884290724055]
    a2DRenderView2.FillLightKFRatio = 3.0
    a2DRenderView2.Background2 = [0.0, 0.0, 0.16500000000000001]
    a2DRenderView2.FillLightAzimuth = -10.0
    a2DRenderView2.LODResolution = 50.0
    a2DRenderView2.BackgroundTexture = []
    a2DRenderView2.HeadPose = [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]
    a2DRenderView2.InteractionMode = '3D'
    a2DRenderView2.StencilCapable = 1
    a2DRenderView2.LightIntensity = 1.0
    a2DRenderView2.CameraFocalPoint = [-0.5, 0.0, 0.0]
    a2DRenderView2.ImageReductionFactor = 2
    a2DRenderView2.CameraViewAngle = 30.0
    a2DRenderView2.CameraParallelScale = 3.2995694628226553
    a2DRenderView2.EyeAngle = 2.0
    a2DRenderView2.HeadLightKHRatio = 3.0
    a2DRenderView2.StereoRender = 0
    a2DRenderView2.KeyLightIntensity = 0.75
    a2DRenderView2.BackLightAzimuth = 110.0
    a2DRenderView2.AxesVisibility = 0
    a2DRenderView2.OrientationAxesInteractivity = 0
    a2DRenderView2.UseInteractiveRenderingForSceenshots = 0
    a2DRenderView2.UseOffscreenRendering = 0
    a2DRenderView2.Background = [0.31999694819562063, 0.34000152590218968, 0.42999923704890519]
    a2DRenderView2.UseOffscreenRenderingForScreenshots = 1
    a2DRenderView2.NonInteractiveRenderDelay = 2
    a2DRenderView2.CenterOfRotation = [0.0, 0.0, 0.0]
    a2DRenderView2.CameraParallelProjection = 0
    a2DRenderView2.CompressorConfig = 'vtkSquirtCompressor 0 3'
    a2DRenderView2.HeadLightWarmth = 0.5
    a2DRenderView2.MaximumNumberOfPeels = 4
    a2DRenderView2.LightDiffuseColor = [1.0, 1.0, 1.0]
    a2DRenderView2.StereoType = 'Red-Blue'
    a2DRenderView2.DepthPeeling = 1
    a2DRenderView2.BackLightKBRatio = 3.5
    a2DRenderView2.StereoCapableWindow = 1
    a2DRenderView2.CameraViewUp = [0.0, 1.0, 0.0]
    a2DRenderView2.LightType = 'HeadLight'
    a2DRenderView2.LightAmbientColor = [1.0, 1.0, 1.0]
    a2DRenderView2.WandPose = [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]
    a2DRenderView2.RemoteRenderThreshold = 3.0
    a2DRenderView2.KeyLightElevation = 50.0
    a2DRenderView2.CenterAxesVisibility = 1
    a2DRenderView2.MaintainLuminance = 0
    a2DRenderView2.StillRenderImageReductionFactor = 1
    a2DRenderView2.BackLightWarmth = 0.5
    a2DRenderView2.FillLightElevation = -75.0
    a2DRenderView2.MultiSamples = 0
    a2DRenderView2.FillLightWarmth = 0.40000000000000002
    a2DRenderView2.AlphaBitPlanes = 1
    a2DRenderView2.LightSwitch = 1
    a2DRenderView2.OrientationAxesVisibility = 1
    a2DRenderView2.CameraClippingRange = [14.902355447816815, 15.278677555084915]
    a2DRenderView2.BackLightElevation = 0.0
    a2DRenderView2.ViewTime = 0.0
    a2DRenderView2.OrientationAxesOutlineColor = [1.0, 1.0, 1.0]
    a2DRenderView2.LODThreshold = 5.0
    a2DRenderView2.CollectGeometryThreshold = 100.0
    a2DRenderView2.UseGradientBackground = 0
    a2DRenderView2.KeyLightWarmth = 0.59999999999999998
    a2DRenderView2.OrientationAxesLabelColor = [1.0, 1.0, 1.0]
    
    input = CreateProducer( datadescription, "input" )
    
    a1_Iterations_PiecewiseFunction = CreatePiecewiseFunction( Points=[0.0, 0.0, 1.0, 1.0] )
    
    a1_Iterations_PVLookupTable = GetLookupTableForArray( "Iterations", 1, Discretize=1, RGBPoints=[1.8648648262023926, 0.23000000000000001, 0.29899999999999999, 0.754, 100.0, 0.70599999999999996, 0.016, 0.14999999999999999], UseLogScale=0, VectorComponent=0, NanColor=[0.25, 0.0, 0.0], NumberOfTableValues=256, ColorSpace='Diverging', VectorMode='Magnitude', HSVWrap=0, ScalarRangeInitialized=1.0, LockScalarRange=0 )
    
    DataRepresentation3 = Show()
    DataRepresentation3.Opacity = 1.0
    DataRepresentation3.Origin = [0.0, 0.0, 0.0]
    DataRepresentation3.Scale = [1.0, 1.0, 1.0]
    DataRepresentation3.UseXYPlane = 1
    DataRepresentation3.ColorAttributeType = 'POINT_DATA'
    DataRepresentation3.Position = [0.0, 0.0, 0.0]
    DataRepresentation3.ColorArrayName = 'Iterations'
    DataRepresentation3.Visibility = 1
    DataRepresentation3.Slice = 0
    DataRepresentation3.LookupTable = a1_Iterations_PVLookupTable
    DataRepresentation3.MapScalars = 1
    DataRepresentation3.SliceMode = 'XY Plane'
    DataRepresentation3.Pickable = 1
    DataRepresentation3.Orientation = [0.0, 0.0, 0.0]
    

    for writer in cp_writers:
        if timestep % writer.cpFrequency == 0 or datadescription.GetForceOutput() == True:
            writer.FileName = writer.cpFileName.replace("%t", str(timestep))
            writer.UpdatePipeline()

    if timestep % 1 == 0 or datadescription.GetForceOutput() == True:
        renderviews = servermanager.GetRenderViews()
        imagefilename = "image_%t.png"
        for view in range(len(renderviews)):
            fname = imagefilename.replace("%v", str(view))
            fname = fname.replace("%t", str(timestep))
            WriteImage(fname, renderviews[view])

    # explicitly delete the proxies -- we do it this way to avoid problems with prototypes
    tobedeleted = GetNextProxyToDelete()
    while tobedeleted != None:
        Delete(tobedeleted)
        tobedeleted = GetNextProxyToDelete()

def GetNextProxyToDelete():
    iter = servermanager.vtkSMProxyIterator()
    iter.Begin()
    while not iter.IsAtEnd():
        if iter.GetGroup().find("prototypes") != -1:
            iter.Next()
            continue
        proxy = servermanager._getPyProxy(iter.GetProxy())
        proxygroup = iter.GetGroup()
        if proxygroup != 'timekeeper' and proxy != None and proxygroup.find("pq_helper_proxies") == -1 :
            return proxy
        iter.Next()

    return None

def CreateProducer(datadescription, gridname):
    "Creates a producer proxy for the grid"
    if not datadescription.GetInputDescriptionByName(gridname):
        raise RuntimeError, "Simulation input name '%s' does not exist" % gridname
    grid = datadescription.GetInputDescriptionByName(gridname).GetGrid()
    producer = PVTrivialProducer()
    producer.GetClientSideObject().SetOutput(grid)
    if grid.IsA("vtkImageData") == True or grid.IsA("vtkStructuredGrid") == True or grid.IsA("vtkRectilinearGrid") == True:
        extent = datadescription.GetInputDescriptionByName(gridname).GetWholeExtent()
        producer.WholeExtent= [ extent[0], extent[1], extent[2], extent[3], extent[4], extent[5] ]

    producer.UpdatePipeline()
    return producer


def CreateWriter(proxy_ctor, filename, freq, cp_writers):
    writer = proxy_ctor()
    writer.FileName = filename
    writer.add_attribute("cpFrequency", freq)
    writer.add_attribute("cpFileName", filename)
    cp_writers.append(writer)
    return writer
